
<!DOCTYPE HTML>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<title>Flatcain</title>
<link rel="stylesheet" type="text/css" href="appfolder/styles/bootstrap.css">
<link rel="stylesheet" type="text/css" href="appfolder/fonts/bootstrap-icons.css">
<link rel="preconnect" href="https://fonts.gstatic.com">
<link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@500;600;700&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
<link rel="manifest" href="appfolder/_manifest.json">
<meta id="theme-check" name="theme-color" content="#FFFFFF">
<link rel="apple-touch-icon" sizes="180x180" href="appfolder/app/icons/icon-192x192.png"></head>
<body class="theme-dark">
<div id="preloader"><div class="spinner-border color-highlight" role="status"></div></div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>


<div id="page">

<div id="footer-bar" class="footer-bar-1 footer-bar-detached">
<a href="?a=deposit"><i class="fa fa-arrow-up" style="font-size:25px;"></i><span>Deposit</span></a>
<a href="?a=withdraw"><i class="fa fa-arrow-down" style="font-size:25px;"></i><span>Withdraw</span></a>
<a href="?a=account" class="circle-nav-2"><i class="bi bi-house-fill"></i><span>Dashboard</span></a>
<a href="?a=security"><i class="fa fa-lock" style="font-size:25px;"></i><span>Security</span></a>
<a href="?a=edit_account"><i class="bi bi-three-dots"></i><span>More</span></a>
</div>

<div class="page-content footer-clear">

<div class="pt-3">
<div class="page-title d-flex">
<div class="align-self-center me-auto">
<p class="color-white">Hello {$userinfo.username}</p>
<h1 class="color-theme">Welcome</h1>
</div>
<div class="align-self-center ms-auto">
<a href="?a=news" class="icon gradient-blue color-white shadow-bg shadow-bg-xs rounded-m">
<i class="bi bi-bell-fill font-17"></i>
<em class="badge bg-red-dark color-white scale-box">3</em>
</a>
<a href="#" data-bs-toggle="dropdown" class="icon gradient-blue shadow-bg shadow-bg-s rounded-m">
<img src="appfolder/images/pictures/avater.png" width="45" class="rounded-m" alt="img">
</a>

<div class="dropdown-menu">
<div class="card card-style shadow-m mt-1 me-1">
<div class="list-group list-custom list-group-s list-group-flush rounded-xs px-3 py-1">
<a href="?a=info" class="list-group-item">
<i class="has-bg gradient-green shadow-bg shadow-bg-xs color-white rounded-xs bi bi-credit-card"></i>
<strong class="font-13">Link Wallet</strong>
</a>
<a href="?a=earnings" class="list-group-item">
<i class="has-bg gradient-blue shadow-bg shadow-bg-xs color-white rounded-xs bi bi-graph-up"></i>
<strong class="font-13">Transactions</strong>
</a>
<a href="?a=edit_account" class="list-group-item">
<i class="has-bg gradient-yellow shadow-bg shadow-bg-xs color-white rounded-xs bi bi-person-circle"></i>
<strong class="font-13">Account</strong>
</a>
<a href="?a=logout" class="list-group-item">
<i class="has-bg gradient-red shadow-bg shadow-bg-xs color-white rounded-xs bi bi-power"></i>
<strong class="font-13">Log Out</strong>
</a>
</div>
</div>
</div>
</div>
</div>
</div>
<style>
#customers {
  font-family: Arial, Helvetica, sans-serif;
  border-collapse: collapse;
  width: 100%;
}

#customers td, #customers th {
  border: 1px solid #ddd;
  padding: 8px;
}

#customers tr:nth-child(even){
background-color: #f2f2f2;}

#customers tr:hover {
background-color: #ddd;}

#customers th {
  padding-top: 12px;
  padding-bottom: 12px;
  text-align: left;
  background-color: #4A89DC;
  color: white;
}
</style>







<div class="card card-style">
<div class="content mb-0">
<div class="tabs tabs-pill" id="tab-group-2">
<div class="tab-controls rounded-m p-1 overflow-visible">
<a class="font-13 rounded-s py-1 shadow-bg shadow-bg-s" data-bs-toggle="collapse" href="#tab-4" aria-expanded="true">Withdraw</a>

</div>
<div class="mt-3"></div>

<div class="collapse show" id="tab-4" data-bs-parent="#tab-group-2">


<div class="form-custom form-label form-icon mb-3">
<i class="bi bi-currency-dollar font-14"></i>
<input type="text" disabled placeholder="{$currency_sign}{$ab_formated.total}" class="form-control rounded-xs" id="c1"   required />
<label for="c1" class="color-theme">Account Balance</label>
<div class="valid-feedback">Excellent!</div>

<span>(Account Balance)</span>
</div>  

<div class="form-custom form-label form-icon mb-3">
<i class="bi bi-currency-dollar font-14"></i>
<input type="text" disabled placeholder="$" class="form-control rounded-xs" id="c1"   required />
<label for="c1" class="color-theme">Pending Withdrawals</label>
<div class="valid-feedback">Excellent!</div>
<div class="invalid-feedback">Name is Missing or Invalid</div>
<span>(Account Balance)</span>
</div>  
<div class="divider my-2"></div>
<h3>Coin Balance</h3>

{foreach from=$ps item=p}
<div class="divider my-2"></div>
<a href="#"  class="d-flex py-1 mb-2">
<div class="align-self-center">
<h5 class="pt-1 mb-n1">{$p.name|escape:html}</h5>
<p class="mb-0 font-11 opacity-70">Pending</p>
</div>
<div class="align-self-center ms-auto text-end">
<h4 class="pt-1 mb-n1">{$currency_sign}{$p.available}</h4>
<p class="mb-0 font-11 color-red-light">{$currency_sign}{$p.pending}</p>
</div>
</a>
{/foreach}
<div class="divider my-2"></div>

</div>

<div class="card card-style gradient-red rounded-s shadow-bg shadow-bg-xs mb-3">
<div class="content my-2">
<a href="#"  class="d-flex">
<div class="align-self-center">
<h1 class="mb-0 font-14"><i class="bi bi-droplet color-white pe-3"></i></h1>
</div>
{if $have_available}
<a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-bill" class="d-flex">

<div class="align-self-center ms-auto">
<h5 class="color-white font-600 mb-0 mt-0 font-14 line-height-s">
Tap to Withdraw
</h5>
</div>
</a>
{else}
<br><br>
<div class="align-self-center">
<h5 class="color-white font-600 mb-0 mt-0 font-14 line-height-s">
You have no funds to withdraw.
</h5>
</div>
{/if}

</a>
</div>
</div>


  
    
{if $say eq 'processed'}
{if $batch eq ''}Withdrawal request has been successfully saved.{else} Withdrawal has been processed. Batch id: {$batch}{/if}
<br><br>
{/if}

{if $fatals}
  {if $fatal == 'times_limit' || $fatals.times_limit}
  <div class="msg">You can withdraw {$settings.limit_withdraw_period_times} per {$settings.limit_withdraw_period_date} only.</div>
  {/if}

{else}
{if $say eq 'ec_forbidden' || $errors.ec_forbidden}
Sorry, withdraw for this processing is temproary forbidden.<br><br>
{/if}
{if $say eq 'on_hold' || $errors.on_hold}
Sorry, this amount on hold now.<br><br>
{/if}
{if $say eq 'zero' || $errors.zero}
Sorry, you can't request a withdraw smaller than {$currency_sign}0.00 only<br><br>
{/if}
{if $say eq 'less_min' || $errors.less_min}
Sorry, you can request not less than {$currency_sign}{*$settings.min_withdrawal_amount*}{$fees.amount_min}<br><br>
{/if}
{if $say eq 'greater_max' || $errors.greater_max}
Sorry, you can request not greater than {$currency_sign}{*$settings.max_withdrawal_amount*}{$fees.amount_max}<br><br>
{/if}
{if $say eq 'daily_limit' || $errors.daily_limit}
Sorry, you have exceeded a daily limit<br><br>
{/if}
{if $say eq 'not_enought' || $errors.not_enought}<b style="color:red">
Sorry, you have requested the amount larger than the one on your balance.</b><br><br>
{/if}
{if $say eq 'invalid_transaction_code' || $errors.invalid_transaction_code}
You have entered the invalid transaction code.<br><br>
{/if}
{if $say eq 'invalid_tfa_code' || $errors.invalid_tfa_code}
You have entered invalid 2FA code.<br><br>
{/if}
{if $say eq 'no_deposits' || $errors.no_deposits}
You have not done any deposits yet. Withdrawal function will be available after a deposit.
<br><br>
{/if}
{if $say eq 'no_active_deposits' || $errors.no_active_deposits}
You must have active deposit to withdraw.
{/if}
{if $say eq 'no_account' || $errors.no_account}
Please, provide your aacount to withdraw funds to first <a href="{"?a=edit_account"|encurl}">here</a>.
{/if}
{if $errors.demo}
Withdraw is not available for demo account.
{/if}
{if $errors.turing_image}Invalid turing image<br><br>{/if}

{if $preview}

<div class="offcanvas offcanvas-bottom offcanvas-detached rounded-m show" style="display: block; visibility: visible;" aria-modal="true" role="dialog">

<div class="menu-size" style="height:530px;">
<div class="d-flex mx-3 mt-3 py-1">
<div class="align-self-center">
<h1 class="mb-0">Process Your Withdrawal</h1>
</div>
<div class="align-self-center ms-auto">
<a href="#" class="ps-4 shadow-0 me-n2" data-bs-dismiss="offcanvas">
<i class="bi bi-x color-red-dark font-26 line-height-xl"></i>
</a>
</div>
</div>
<div class="divider divider-margins mt-3 mb-2"></div>
<div class="content mt-0">
<form method=post>
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=withdraw>
<input type=hidden name=amount value={$amount}>
<input type=hidden name=ec value={$ec}>
<input type=hidden name=comment value="{$comment|escape:html}">

<table cellspacing=0 cellpadding=2 border=0 class="form deposit_confirm">
<tr>
 <th>Payment System:</th>
 <td>{$currency}</td>
</tr>
<tr>
 <th>Account:</th>
 <td>{$account}</td>
</tr>
<tr>
 <th>Debit Amount:</th>
 <td>{$currency_sign}{$amount}</td>
</tr>
{* old
<tr>
 <th>Withdrawal Fee:</th>
 <td>
{if $settings.withdrawal_fee > 0 || $settings.withdrawal_fee_min > 0}
  {if $settings.withdrawal_fee > 0}{$settings.withdrawal_fee}%{/if} 
  {if $settings.withdrawal_fee_min > 0}min. {$currency_sign}{$settings.withdrawal_fee_min}{/if}
{else}
We have no fee for this operation.
{/if}
</td>
</tr>
*}
<tr>
 <th>Withdrawal Fee:</th>
 <td>
{if $fees.fee > 0}
  {$fees.percent}% + {$currency_sign}{$fees.add_amount} (min. {$currency_sign}{$fees.fee_min} max. {if $fees.fee_max}{$currency_sign}{$fees.fee_max}{else}no{/if})
{else}
We have no fee for this operation.
{/if}
</td>
</tr>

{if $converted}
<tr>
 <th>Credit Amount:</th>
 <td>{$currency_sign}{$converted.amount}</td>
</tr>
<tr>
 <th>{$converted.fiat} Amount:</th>
 <td>{$to_withdraw}</td>
</tr>
{else}
<tr>
 <th>Credit Amount:</th>
 <td>{$currency_sign}{$to_withdraw}</td>
</tr>
{/if}

{*
<tr>
 <td colspan=2>You are withdrawing <b>{$currency_sign}{$amount}</b> of {$currency}. 
{if $settings.withdrawal_fee > 0 || $settings.withdrawal_fee_min > 0} Our fee is 
{if $settings.withdrawal_fee > 0}<b>{$settings.withdrawal_fee}%</b>{/if}
{if $settings.withdrawal_fee > 0 && $settings.withdrawal_fee_min > 0} or {/if}
{if $settings.withdrawal_fee_min > 0} <b>{$currency_sign}{$settings.withdrawal_fee_min}</b>{if $settings.withdrawal_fee > 0} as a minimum{/if}{/if}
.
{else}
We have no fee for this operation. 
{/if}
</td>
</tr>
<tr>
 <td colspan=2>Actually you will acquire the total of <b>{$currency_sign}{$to_withdraw}</b> on your {$currency} account {if $account}{$account}{/if}.</td>
</tr>
*}
{if $comment}
<tr>
 <th>Note:</th>
 <td>{$comment|escape:html}</td>
</tr>
{/if}
{if $settings.use_transaction_code && $userinfo.transaction_code}
<tr>
 <th>Transaction Code:</th>
 <td><input type="password" name="transaction_code" class=inpts size=15></td>
</tr>
{/if}
{include file="captcha.tpl" action="withdrawal"}
{if $userinfo.tfa_settings.withdraw}
<tr>
 <th>2FA Code:</th>
 <td><input type="text" name="tfa_code" class=inpts size=15> <input type="hidden" name="tfa_time" id="tfa_time"></td>
</tr>
{literal}
<script language=javascript>
document.getElementById('tfa_time').value = (new Date()).getTime();
</script>
{/literal}
{/if}
<tr>
 <td colspan=2><input type=submit value="Confirm" class="form-control rounded-xs"></td>
</tr></table>
</form>
</div>
</div>
</div>

{else}
<div id="menu-bill" class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">

<div class="menu-size" style="height:530px;">
<div class="d-flex mx-3 mt-3 py-1">
<div class="align-self-center">
<h1 class="mb-0">Process Your Withdrawal</h1>
</div>
<div class="align-self-center ms-auto">
<a href="#" class="ps-4 shadow-0 me-n2" data-bs-dismiss="offcanvas">
<i class="bi bi-x color-red-dark font-26 line-height-xl"></i>
</a>
</div>
</div>
<div class="divider divider-margins mt-3 mb-2"></div>
<div class="content mt-0">
  
    
<form method=post>
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=preview>
<input type=hidden name=say value="">


<div class="form-custom form-label form-icon mb-3">


<table cellspacing=0 cellpadding=2 border=0>
    <th></th>
 <th></th>
{foreach from=$ps item=p}
<tr>
     <td>{if $p.available > 0}{if $p.status > 0 || $p.available > 0}
 
 <input type="radio" name="ec" value="{$p.id}" {if $frm.ec == $p.id}checked{/if} required>
 {/if}
 {/if}
 </td>
  <td>{$p.name|escape:html} <b style="color:gray">{$currency_sign}{$p.available}</b></td>
  </tr>
  {/foreach}
</table>

<label for="c66" class="color-theme">Select Payment</label>
<div class="valid-feedback">Select a payment to processed</div>
</div> 
<div class="form-custom form-label form-icon mb-3">
<i class="bi bi-currency-dollar font-12"></i>
<input type="text" name=amount value="{$frm.amount|amount_format|default:"10.00"}" class="form-control rounded-xs" id="c3"   required />


<span>(required)</span>
</div>
    <textarea name=comment hidden class=inpts cols=45 rows=4>{$userinfo.username}</textarea>
   
<div class="divider my-2"></div>


<input type=submit value="Continue" class="mx-3 btn btn-full gradient-blue shadow-bg shadow-bg-s">
</form>
{/if}
{/if}
</div>
</div>
</div>



</div>
<div id="menu-sidebar" data-menu-active="nav-welcome"  class="offcanvas offcanvas-start offcanvas-detached rounded-m">
    
</div>


</div>

<script src="appfolder/scripts/bootstrap.min.js"></script>
<script src="appfolder/scripts/custom.js"></script>
</body> 